' API Written by Predictive Engineering 2014, Rev-0 (Tested on Femap v11.1.1)
'
' This API creates thermal loads from select output sets and sets up thermal stress
' analysis sets corresponding to the loads
'
' Please feel free to suggest any improvements to www.PredictiveEngineering.com
'
' History
' - 04/6/14 Rev-0  Nate Anderson <nathan.anderson@predictiveengineering.com>
'   * initial release

Sub Main()
' Attach to femap
    Dim App As femap.model
    Set App = GetObject(, "femap.model")
    Dim rc As Integer
    
' Dims to hold output ids and temp values
    Dim resIDS As Variant
    Dim addIDS As Variant
    Dim Temps As Variant

' node set for all model nodes
    Dim allSet As femap.Set
    Set allSet = App.feSet
    rc = allSet.AddAll(FT_NODE)
    
' node set for adding load values
    Dim ndSet As femap.Set
    Set ndSet = App.feSet
    
' set for results nodes.
    Dim resSet As femap.Set
    Set resSet = App.feSet
    
    Dim n As Long
    
' load set object
    Dim ldSet As femap.LoadSet
    Set ldSet = App.feLoadSet
    
' load definition
    Dim ldDef As femap.LoadDefinition
    Set ldDef = App.feLoadDefinition

' load object
    Dim load As femap.LoadNTemp
    Set load = App.feLoadNTemp
    load.color = 10
    load.layer = 1
    
' Constraint set
    Dim bc As BCSet
    Set bc = App.feBCSet
    
' title and id dims for new loadsets
    Dim sTitle As String
    Dim iNewLoadSetID As Integer

' get the output
    Dim oSet As femap.Set
    Set oSet = App.feSet
    Dim outSet As OutputSet
    Set outSet = App.feOutputSet
    Dim Output As Output
    
    rc = oSet.Select(FT_OUT_CASE, True, "Select Output Sets to Convert to Thermal Stress Analyses")

' Analysis Set object
    Dim analysisSet As AnalysisMgr
    Set analysisSet = App.feAnalysisSet
    Dim analysisSetID As Long

    rc = analysisSet.InitAnalysisMgr(FAM_NX_NASTRAN, FAT_STATIC, False)
    rc = bc.SelectID("Select Constraint Set for Thermal Stress Analysis")
    analysisSet.BCSet(0) = bc.ID
    analysisSet.title = "Thermal Stress: Load from Transient Results"

' request displacement
        analysisSet.Output(2) = -1

' request Stress
        analysisSet.Output(16) = -1

' create analysis set
        analysisSetID = analysisSet.NextEmptyID
        rc = analysisSet.Put(analysisSetID)
        rc = App.feAppMessage(FCM_NORMAL, "Analysis Set """ & analysisSet.title & """ created")

' Analysis Case object
    Dim analysisCS As AnalysisCase
    Set analysisCS = App.feAnalysisCase
    Dim analysisCSID As Long
    analysisCSID = 1

' Process all the selected output sets
    While oSet.Next
        outSet.Get (oSet.CurrentID)
        iNewLoadSetID = outSet.ID + 10000
        sTitle = "Thermal Load from Results (LC " & CStr(outSet.ID) & ")"
    
' define loadset properties
        ldSet.title = sTitle
        ldSet.ID = iNewLoadSetID
        
' save loadSet to database
        rc = ldSet.Put(iNewLoadSetID)
        ldDef.setID = ldSet.ID
        rc = ldDef.PutAll(ldDef.NextEmptyID, FT_NTHERM_LOAD, FLT_NTEMPERATURE, "Temperature on Node")
        load.LoadDefinitionID = ldDef.ID
        load.setID = ldSet.ID
        Set Output = outSet.Vector(31) ' Temp vector
        
' get all the results and then create a node set from the IDS array
        rc = Output.GetOutputList(n, resIDS, Temps)
        rc = resSet.AddArray(n, resIDS)
        
' intersect resSet and allSet to get a set of existing nodes to query results
' this is done because the results set could have data for nodes that are not
' longer in the model
        rc = ndSet.AddCommon(resSet.ID, allSet.ID)
        
' query the results for only ids in ndSet
        rc = Output.GetOutputListAtSet(ndSet.ID, 0#, Temps)
        rc = ndSet.GetArray(n, addIDS)
    
' create a load from the output
        rc = load.AddArray(n, True, False, addIDS, Temps, 0)
        rc = App.feAppMessage(FCM_NORMAL, "Load set """ & sTitle & """ created")

' create analysis case
        analysisCS.CaseTitle = "Load (" & CStr(iNewLoadSetID) & ") from Transient Results (Case " & CStr(outSet.ID) & ")"
        analysisCS.BCSet(2) = ldSet.ID
        analysisCS.setID = analysisSetID
        analysisCS.caseID = analysisCSID
        rc = analysisCS.Put(analysisCSID)
        rc = App.feAppMessage(FCM_NORMAL, "Analysis Case " +CStr(analysisCSID)+ " created")

        analysisCSID = analysisCSID + 1
    Wend
    rc = App.feAppMessage(FCM_NORMAL, "")
    rc = App.feAppMessage(FCM_NORMAL, "API program complete")
End Sub
